import os
import xml.etree.ElementTree as ET
from zeep import Client,Settings,xsd
import base64
import hashlib
import pyodbc
import shutil
from datetime import datetime

class main:
    # Metodo inicial que chama todas as outras metodos.
    def __init__(self):
        self.recuperaXML()
        self.conexaoBanco()
        self.consultaBanco()
        self.conexaoWebService()
        self.variaveisXML()
        self.recuperarParametrosEnvio()
        self.substituiArquivos()
        self.trocaTexto()
        self.contador = self.contador -1
        
        if (self.contador>0):
            main()


    # Lê o arquivo XML e retorna todos o root dele, contendo todos os parâmetros.
    def recuperaXML(self):
        pastaRaiz = os.path.abspath(__file__)  # Recupera o path do script python
        self.pastaRaiz= ((os.path.split(pastaRaiz))[0])  # Recupera o path do projeto
        self.root = (ET.parse(self.pastaRaiz +'/An.xml')).getroot()  # Abre o arquivo XML
        return
    
    # Realiza a conexão com o banco de dados e retorna o cursor (O link para relazar chamadas ao banco).
    def conexaoBanco(self):
        dadosBanco = self.root.iter('conections')
        queryConexao = ''
        for dado in dadosBanco:
            if (dado.get('service')=='banco'):
                for mapping_tags in dado:
                    queryConexao += mapping_tags.tag + "=" + mapping_tags.text + ";"
        
        self.cursorBanco = (pyodbc.connect(queryConexao)).cursor()
        return

    # Realiza as consultas ao banco de dados e retorna os dados da consulta.
    # Atribui valor as variaveis de classe: resultadoConsultaBanco
    # Utiliza as variaveis locais: resultadoConsultaBanco
    def consultaBanco(self):
        xmlConsultas = self.root.iter('consultaPortaria')
        self.resultadoConsultaBanco = []
        parametros = {'id_protocolo':'','protocolo_formatado':''}

        for i,consulta in enumerate(xmlConsultas):
            texto = consulta.text
            
            if (i==0):
                self.cursorBanco.execute(texto)
                resultado = self.cursorBanco.fetchall()
                self.contador = len(resultado)
                if (len(resultado)==0):
                    print ('Sem novos dados')
                    exit()
                self.resultadoConsultaBanco.append(resultado[0])
                parametros['id_protocolo'] = resultado[0][0]
                parametros['protocolo_formatado'] = resultado[0][1]
            else:
                texto = (consulta.text).replace('$id_protocolo$',str(parametros['id_protocolo']))
                self.cursorBanco.execute(texto)
                resultado = self.cursorBanco.fetchall()
                for res in resultado:
                    self.resultadoConsultaBanco.append(res)
        return
    
    # Realiza a leitura do root do XML para criação de string de conexão.
    # Atribui valor as variáveis de classe: parametrosConsultaWebService, o qual retorna a string de conexão.
    def conexaoWebService(self):
        self.parametrosConsultaWebService = {}
        self.defaultWebService = {}
        self.url = ''

        for dado in self.root.iter('conections'):
            if (dado.get('service')=='webservice' or dado.get('service')=='Portaria252'):
                if (dado.get('url')):
                    self.url = dado.get('url')

                for mapping_tags in dado:
                    self.parametrosConsultaWebService[mapping_tags.tag] = mapping_tags.text
                    if (len(self.defaultWebService)<3):
                        self.defaultWebService[mapping_tags.tag] = mapping_tags.text
        
        self.parametrosConsultaWebService['ProtocoloProcedimento'] = self.resultadoConsultaBanco[0][1]
        return
    
    # Lê o root do XML para definição das variaveis que serão trocadas, montando um array associativo.
    # Atribui valor as variáveis de classe: parametrosTrocaTexto
    def variaveisXML(self):
        self.parametrosTrocaTexto = {}
        for dado in self.root.iter('metadadosPortaria'):
            for mapping_tags in dado:
                self.parametrosTrocaTexto[mapping_tags.tag] = mapping_tags.text
        return
    
    # Realiza a consulta ao WebService para obtenção dos dados necessários.
    # Chamado fora da função principal, necessário passagem do serviço que será conectado.
    # Utiliza as variaveis locais: settings, resultadoWebService
    def consultaWebService(self,servico,subprocessos):
        temporario={}
        settings = Settings(strict=False, xml_huge_tree=True)
        resultadoWebService = eval('Client("'+self.url+'",settings=settings).service.'+servico)(**subprocessos)

        # Faz a leitura do array associativo e substitui as variáveis por textos recuperados via Banco ou WebService.
        for VariaveisASeremTrocadas in self.parametrosTrocaTexto:
            # Quebra o texto da variavel a ser trocada para associar a busca no WebService
            
            splitTexto = self.parametrosTrocaTexto[VariaveisASeremTrocadas].split('.')
            consulta = 'resultadoWebService'

            # Verifica se é um array, para unir todas as informações em uma unica célula da coluna
            if (splitTexto[0]=='array'):
                variaveisDoArray = False
                check = False
                temp =[]
                arrayWebService = resultadoWebService[splitTexto[1]]
                textoSemArray = splitTexto[2:]
                for i in range(len(textoSemArray)):
                    if (len(arrayWebService)==0):
                        temporario[VariaveisASeremTrocadas]='--'
                        break

                    if (not variaveisDoArray):
                        if (textoSemArray[i]=='$'):
                            variaveisDoArray=True
                        else: 
                            arrayWebService=arrayWebService[textoSemArray[i]]
                    else:
                        tamanhoArray = len(arrayWebService)
                        for n in range(tamanhoArray):
                            if (not check):
                                temp.append(arrayWebService[n][textoSemArray[i]])
                            else:
                                temp[n] = temp[n]+' - '+(arrayWebService[n][textoSemArray[i]])+'\n'
                            
                            if (n==(tamanhoArray-1)):
                                check=True
                temporario[VariaveisASeremTrocadas]=temp

            # Trata os dados que estão em um nível diferente da raiz dos dados obtidos no Webservice
            elif (len(splitTexto)>1):
                for posicao in splitTexto:
                    consulta += '["'+posicao+'"]'
            
                temporario[VariaveisASeremTrocadas] = eval(consulta)

            # Trata os dados que estão no nível raiz do dados obtidos no webservice
            else:
                if (VariaveisASeremTrocadas=='data_limite'):
                    temporario[VariaveisASeremTrocadas] = (resultadoWebService[self.parametrosTrocaTexto[VariaveisASeremTrocadas]])[-4:]+'-'+str((datetime.now()).year)
                else:
                    temporario[VariaveisASeremTrocadas] = resultadoWebService[self.parametrosTrocaTexto[VariaveisASeremTrocadas]]
        self.valoresTrocados.append(temporario)
        return

    # Lê o root do XML e define os parametros para requisição de envio dos arquivos.
    # Atribui valor as variáveis de classe: metadadosXMLAdicionarArquivo, metadadosXMLIncluirDocumento
    def recuperarParametrosEnvio(self):
        qtdArquivosHTMLAdicionarArquivo = 0
        qtdArquivosHTMLIncluirDocumento = 0
        self.metadadosXMLAdicionarArquivo = {}
        self.metadadosXMLIncluirDocumento = {}

        for dado in self.root.iter('conections'):
            # Serviço AdicionarArquivo
            if (dado.get('service') == 'AdicionarArquivo'):
                temp = {}
                for mapping_tags in dado:
                    temp[mapping_tags.tag] = mapping_tags.text
                self.metadadosXMLAdicionarArquivo[qtdArquivosHTMLAdicionarArquivo] = temp
                qtdArquivosHTMLAdicionarArquivo = qtdArquivosHTMLAdicionarArquivo+1

            # Serviço IncluirDocumento
            if (dado.get('service') == 'incluirDocumento'):
                temp = {}
                for mapping_tags in dado:
                    if (mapping_tags.text is not None):
                        splitXmlText = (mapping_tags.text).split('$')
                        if len(splitXmlText)>1:
                            temp[mapping_tags.tag] = self.parametrosConsultaWebService[splitXmlText[1]]
                        else:
                            temp[mapping_tags.tag]=mapping_tags.text
                    else:
                        temp[mapping_tags.tag]=mapping_tags.text
                self.metadadosXMLIncluirDocumento[qtdArquivosHTMLIncluirDocumento] = {'Documento':temp}
                qtdArquivosHTMLIncluirDocumento = qtdArquivosHTMLIncluirDocumento+1
        return

    # Substitui os arquivos que foram modificados anteriormente pelos originais sem modificação.
    def substituiArquivos(self):
        for i in range(len(self.metadadosXMLAdicionarArquivo)):
            destino = self.pastaRaiz+"/job/"+self.metadadosXMLAdicionarArquivo[i]['Nome']
            origem = self.pastaRaiz+"/job/padraoPortaria/"+self.metadadosXMLAdicionarArquivo[i]['Nome']
            shutil.copyfile(origem, destino)

    # Realiza a troca das variaveis do HTML para as definidas no parametrosTrocaTexto
    def trocaTexto(self):
        settings = Settings(strict=False, xml_huge_tree=True)

        subprocesso = self.parametrosConsultaWebService
        self.valoresTrocados = []
        for processo in self.resultadoConsultaBanco[1:]:
            subprocesso['ProtocoloProcedimento'] = processo[1]
            self.consultaWebService('consultarProcedimento',subprocesso)

        for i in range(len(self.metadadosXMLAdicionarArquivo)):
            arquivo = self.pastaRaiz+"/job/"+self.metadadosXMLAdicionarArquivo[i]['Nome']
            conteudo = open(arquivo, "r")

            texto = conteudo.read()
            splitTexto = texto.split('$')
            tamanhoSplitTexto = len(splitTexto)
            
            if (tamanhoSplitTexto>1):
                for n in range(tamanhoSplitTexto):
                    if (n%2>0):
                        if (splitTexto[n]=='tabela'):
                            temp =''
                            for z in range(len(self.valoresTrocados)):
                                temp = temp + f'''<tr>
                                    <td style="border-collapse: collapse; border-width: 0px 1px 1px 1px; border-style: solid;">
                                        --
                                    </td>
                                    <td style="border-collapse: collapse; border-width: 0px 1px 1px 1px; border-style: solid;">
                                        {"<br>".join(self.valoresTrocados[z]['classificacao_descricao'])}
                                    </td>
                                    <td style="border-collapse: collapse; border-width: 0px 1px 1px 1px; border-style: solid;">
                                        &nbsp;
                                    </td>
                                    <td style="border-collapse: collapse; border-width: 0px 1px 1px 1px; border-style: solid;">
                                        &nbsp;
                                    </td>
                                    <td style="border-collapse: collapse; border-width: 0px 1px 1px 1px; border-style: solid;">
                                        {self.valoresTrocados[z]['data_limite']}
                                    </td>
                                    <td style="border-collapse: collapse; border-width: 0px 1px 1px 1px; border-style: solid;">
                                        &nbsp;
                                    </td>
                                    <td style="width: 9%; word-wrap: break-word; border-collapse: collapse; border-width: 0px 1px 1px 1px; border-style: solid;">
                                        {self.valoresTrocados[z]['identificador_processo']}

                                    </td>
                                    <td style="width: 9%; word-wrap: break-word; border-collapse: collapse; border-width: 0px 1px 1px 1px; border-style: solid;">
                                        {self.valoresTrocados[z]['titulo']}
                                    </td>
                                    <td style="width: 9%; word-wrap: break-word; border-collapse: collapse; border-width: 0px 1px 1px 1px; border-style: solid;">
                                        &nbsp;
                                    </td>
                                    <td style="width: 9%; word-wrap: break-word; border-collapse: collapse; border-width: 0px 1px 1px 1px; border-style: solid;">
                                        {self.valoresTrocados[z]['autor']}
                                    </td>
                                    <td style="width: 9%; word-wrap: break-word; border-collapse: collapse; border-width: 0px 1px 1px 1px; border-style: solid;">
                                        {self.valoresTrocados[z]['indicacao_anexo']}
                                    </td>
                                    <td style="width: 9%; word-wrap: break-word; border-collapse: collapse; border-width: 0px 1px 1px 1px; border-style: solid;">
                                        {"<br>".join(self.valoresTrocados[z]['classificacao_descricao'])}
                                    </td>
                                    <td style="width: 9%; word-wrap: break-word; border-collapse: collapse; border-width: 0px 1px 1px 1px; border-style: solid;">
                                        &nbsp;
                                    </td>
                                    <td style="width: 9%; word-wrap: break-word; border-collapse: collapse; border-width: 0px 1px 1px 1px; border-style: solid;">
                                        &nbsp;
                                    </td>
                                    <td style="width: 9%; word-wrap: break-word; border-collapse: collapse; border-width: 0px 1px 1px 1px; border-style: solid;">
                                        &nbsp;
                                    </td>
                                    <td style="width: 9%; word-wrap: break-word; border-collapse: collapse; border-width: 0px 1px 1px 1px; border-style: solid;">
                                        &nbsp;
                                    </td>
                                    <td style="width: 9%; word-wrap: break-word; border-collapse: collapse; border-width: 0px 1px 1px 1px; border-style: solid;">
                                        ws: ConsultarProcedimento NivelAcesso
                                    </td>
                                    </tr>'''
                                
                            splitTexto[n]=temp
            
            texto = "".join(splitTexto)
            
            open(arquivo,'w').writelines(texto)
            conteudo.close()

            conteudo = open(arquivo, "r")
            texto = conteudo.read()

            self.metadadosXMLAdicionarArquivo[i]['Conteudo'] = (base64.b64encode(texto.encode('UTF-8'))).decode('UTF-8')
            self.metadadosXMLAdicionarArquivo[i]['Tamanho'] = os.path.getsize(arquivo)

            md5_hash = hashlib.md5()
            md5_hash.update(texto.encode('UTF-8'))
            self.metadadosXMLAdicionarArquivo[i]['Hash']=md5_hash.hexdigest()
            conteudo.close()

            self.metadadosXMLIncluirDocumento[i]['Documento']['Conteudo'] = self.metadadosXMLAdicionarArquivo[i]['Conteudo']
            juncaoDict = {**self.defaultWebService,**self.metadadosXMLIncluirDocumento[i]}
            incluirDocumento = (Client(self.url,settings=settings).service.incluirDocumento)(**juncaoDict)

            nomeArquivo = (arquivo.split('/'))
            print ('Incluido arquivo: '+nomeArquivo[len(nomeArquivo)-1])
        return

if __name__ == '__main__':
    main()