from zeep import Client,Settings,xsd
from Imports import colorErro,colorPass,base64,os,hashlib
import re

def toDict(dados,retornoBanco):
    webService = {}

    for dado in dados:
        for mapping_tags in dado:
            if (mapping_tags.text):
                if (mapping_tags.text[0]=='$'):
                    valor = mapping_tags.text[1:].split('.')
                    if type(retornoBanco[valor[0]]) is list:
                        subDict=[]
                        for valores in retornoBanco[valor[0]]:
                            subDict.append(valores[valor[1]])
                        webService[mapping_tags.tag]=subDict
                    else:
                        webService[mapping_tags.tag] = retornoBanco[valor[0]][valor[1]]                   
                else:
                    webService[mapping_tags.tag] = mapping_tags.text
            else:
                temp = {}
                for teste in mapping_tags:
                    temp[teste.tag]=teste.text
                
                if (temp=={}):
                    webService[mapping_tags.tag]=xsd.SkipValue
                else:
                    webService[mapping_tags.tag]=temp
    return webService

def uneebusca(dictWebService,dictVariavel,nameMetadatas,url,settings):
    resultDict = {**dictWebService, **dictVariavel}
    return eval('Client(url,settings=settings).service.'+nameMetadatas)(**resultDict)

def obtemSlug(cursor, dictConsulta, xmlConsultas):
    for consultas in xmlConsultas:
        for consulta in consultas:
            if consulta.tag == 'consultaAtom':

                stringConsulta = (consulta.text).split('$') 
                parametros = stringConsulta[1].split('.')
                
                cod = dictConsulta[parametros[0]][parametros[1]]
                if isinstance(cod, list):
                    cod = cod[0][parametros[2]]
                else:
                    cod = cod[parametros[2]]

                stringConsulta = stringConsulta[0] + cod
                cursor.execute(stringConsulta)
                resultadoConsulta = cursor.fetchone()
                if resultadoConsulta != None:
                    slug = resultadoConsulta[0]
                else:
                    slug = 'slug-nao-definido'
                cursor.close()
                print(colorPass+'Realizado: '+consulta.tag+' ao banco')
                return slug


def obtemProtocolo(cursor, xmlConsultas):
    for consultas in xmlConsultas:
        for consulta in consultas:
            if consulta.tag == 'consulta1':
                cursor.execute(consulta.text)
                resultado = cursor.fetchone()
                if resultado != None:
                    i = 0
                    for campo in cursor.description:
                        if campo[0] == 'protocolo_formatado':
                            return re.sub(r'[-/. ]+', '', resultado[i])
                        i+=1
                return '0'

def consultas(a,cursor,b,IdContinua,xmlMetadatas,dictWebService,url):
    dictConsulta={}
    # Cria um dicionario com as infomações fixas
    # Recupera a url para ser usada no Zeep
    for consultas in xmlMetadatas.iter('consultas'):
        for consulta in consultas:

            if not consulta.text or consulta.tag == 'consultaAtom':
                break

            stringConsulta = (consulta.text).split('$')
            if len(stringConsulta) > 1: 
                for posicao in range(len(stringConsulta)):
                    if (bool(re.search('consulta', stringConsulta[posicao]))):
                        parametro = stringConsulta[posicao].split('.')

                        if isinstance(dictConsulta[parametro[0]], list):
                            stringTemp = stringConsulta

                            dictTemp = []
                            for item in dictConsulta[parametro[0]]:
                                stringTemp[posicao] = str(item[parametro[1]])
                                stringTemp = ''.join(stringTemp)

                                cursor.execute(stringTemp)
                                resultadoConsulta = cursor.fetchone()
                                if(resultadoConsulta != None):
                                    chaves = [column[0] for column in cursor.description]
                                    valores = [column for column in resultadoConsulta]
                                    dictTemp.append(dict(zip(chaves, valores)))
                                dictConsulta[consulta.tag] = dictTemp
                                stringTemp = stringConsulta
                        else:
                            stringConsulta[posicao] = str(dictConsulta[parametro[0]][parametro[1]])
                            if posicao == (len(stringConsulta) - 2):
                                stringConsulta = ''.join(stringConsulta)
                                cursor.execute(stringConsulta)
                                resultadoConsulta = cursor.fetchall()

                                #VERIFICA SE O RETORNO É MAIOR QUE 1 SE FOR CONTINUA ADD EM LISTA, SE NÃO EM DICT
                                if(resultadoConsulta != None  and resultadoConsulta!=[]):
                                    if len(resultadoConsulta) > 1:
                                        listTemp = []
                                        for item in resultadoConsulta:
                                            chaves = [column[0] for column in cursor.description]
                                            valores = [column for column in item]
                                            listTemp.append(dict(zip(chaves, valores)))
                                        dictConsulta[consulta.tag] = listTemp
                                    else:
                                        for item in resultadoConsulta:
                                            chaves = [column[0] for column in cursor.description]
                                            valores = [column for column in item]
                                        # Transforma o resultado de chave/valor para tupla (zip) e dps para dicionario (dict) e armazena o resultado em formato dicionoario
                                        dictConsulta[consulta.tag] = dict(zip( chaves , valores ))
                                else:
                                    dictConsulta[consulta.tag] = ''
            else:
                # Concatena o resultado do split da função acima.
                stringConsulta = ''.join(stringConsulta)
                if (IdContinua != -1):
                    stringConsulta = (stringConsulta.split('FROM'))[0]
                    stringConsulta = stringConsulta+' FROM protocolo p2 WHERE protocolo_formatado = "'+IdContinua+'";'

                # Realiza consulta do banco, usando a string descrita no XML
                cursor.execute(stringConsulta)
                resultadoConsulta = cursor.fetchall()
                resultadoConsulta = resultadoConsulta[0]
                # Verifica se a consulta retornou algum dado
                if (resultadoConsulta!=None):
                     # Recupera a chaves/valores (coluna/atributo) de cada uma das consultas
                    chaves = [column[0] for column in cursor.description]
                    valores = [column for column in resultadoConsulta]
                    # Transforma o resultado de chave/valor para tupla (zip) e dps para dicionario (dict) e armazena o resultado em formato dicionoario
                    dictConsulta[consulta.tag] = dict(zip( chaves , valores ))
                else:
                    dictConsulta[consulta.tag] = ''
            print (colorPass+'Realizado: '+consulta.tag+' ao banco')

    # Define parametros de conexão zeep
    settings = Settings(strict=False, xml_huge_tree=True)
    result={}

    for linha in xmlMetadatas.iter('metadatas'):
        #Recupera o name de cada linha da tag metadatas
        nameMetadatas = linha.get('name')
        if nameMetadatas is not None:
        # cria um dicionario das informações recuperadas de cada uma das funções representadas por nameMetadatas
            dictVariavel = toDict(xmlMetadatas.iter(nameMetadatas),dictConsulta)
            consutasDocumentos = []
            listaDict = []
            for posicao in dictVariavel:
                if type(dictVariavel[posicao]) is list:
                    controle = 0
                    if len(listaDict) > 0:
                        for documentos in dictVariavel[posicao]:
                            listaDict[controle][posicao] = documentos
                            controle+=1
                    else:
                        listaDict = []
                        for documentos in dictVariavel[posicao]:
                            dictTemp = {}
                            dictTemp[posicao] = documentos
                            listaDict.append(dictTemp)

            if len(listaDict) > 0:
                controlList = []
                for dictVar in listaDict:
                    for posicao in dictVar:
                        dictVariavel[posicao] = dictVar[posicao]

                    if verificaConsultaRepetida(controlList, dictVar):
                        consutasDocumentos.append(uneebusca(dictWebService,dictVariavel,nameMetadatas,url,settings))
                        controlList.append(dictVar)
                dictConsulta[nameMetadatas]=consutasDocumentos

            if nameMetadatas == 'consultarProcedimento':
                dictBusca = uneebusca(dictWebService,dictVariavel,nameMetadatas,url,settings)
                for posicao in dictBusca:
                    if isinstance(dictBusca[posicao], list):
                        for item in range(len(dictBusca[posicao])):

                            if not 'IdProcedimento' in dictBusca[posicao][item]:
                                dictBusca[posicao][item]['IdProcedimento'] = dictBusca['IdProcedimento']
                dictConsulta[nameMetadatas] = dictBusca

            if nameMetadatas == 'listarAndamentos':
                dictConsulta[nameMetadatas] = uneebusca(dictWebService,dictVariavel,nameMetadatas,url,settings)


            if nameMetadatas == 'listarContatos':
                if (dictVariavel['Sigla']==[] or dictVariavel['Sigla']==[]):
                    dictConsulta[nameMetadatas]=[]
                    break
                else:
                    for posicao in dictVariavel:
                        if posicao.lower() in dictConsulta['consulta11']:
                            dictVariavel[posicao] = dictConsulta['consulta11'][posicao.lower()]


                    consutasDocumentos.append(uneebusca(dictWebService,dictVariavel,nameMetadatas,url,settings))
                    dictConsulta[nameMetadatas]=consutasDocumentos


            print ('Realizado consulta webservice: '+nameMetadatas)
    return dictConsulta

def verificaConsultaRepetida(lista, dictVar):
    for item in lista:
        if item == dictVar:
            return False
    return True

def adicionaCampo(dictTemp, campo, value):
    if not campo in dictTemp:
        for item in range(len(dictTemp)):
            dictTemp[item][campo] = value
    return dictTemp