from Imports import requests,colorErro,colorPass,colorFinish
from arquivos import bagit
import glob
import subprocess
import shutil
import os
import zipfile

def criarBagit(diretorio,diretorio_geral,nome_pasta):
    try:
        bag = bagit.make_bag(diretorio, {'Contact-Name': ''},checksums={"sha256"},encoding="utf-8")
        print (colorFinish+'### BAGIT criado com sucesso! ###'+colorPass)

        # shutil.move(diretorio+'/data/metadata',diretorio)
        # bag.save(manifests=True)

        if bag.is_valid():
            print(colorFinish+'### BAG validada! ###'+colorPass)
        else:
            print(colorErro+"BAG NAO VALIDADA!"+colorPass)
            exit()

    except Exception as e:
        print (e)
        print(colorErro + "Erro ao criar o BAGIT" + colorPass)
        quit()

def zipBag(diretorio,diretorio_geral,nome_pasta,pasta):
    try:
        print(colorFinish+'### Compactando arquivos! ###'+colorPass)
        arquivoZip = diretorio_geral+'/'+nome_pasta+'.zip'
        
        if os.path.exists(arquivoZip):
            os.remove(arquivoZip)
        
        fantasy_zip = zipfile.ZipFile(arquivoZip, 'w')

        for folder, subfolders, files in os.walk(diretorio):
            for file in files:
                fantasy_zip.write(os.path.join(folder, file), os.path.relpath(os.path.join(folder,file), diretorio), compress_type = zipfile.ZIP_DEFLATED)
 
        fantasy_zip.close()
        shutil.rmtree(pasta)

    except OSError as e:
        print(colorErro + "Erro: %s - %s. \n" % (e.filename, e.strerror) + colorPass)