from Imports import requests, colorErro, colorPass, colorFinish
import shutil
import json
import os.path
import re

def verificaProcesso(infoServer, pastaRaiz, processo):
    if verificaArquivo(infoServer, pastaRaiz + '/logs/idEnviados.txt', processo):
        print(colorFinish+'PROCESSO JÁ ENVIADO!!')
        exit()

    if verificaArquivo(infoServer, pastaRaiz + '/logs/arquivados.txt', processo):
        print(colorPass+'PROCESSO JÁ ARQUIVADO!!')
        exit()

    if verificaArquivo(infoServer, pastaRaiz + '/logs/erros.txt', processo):
        print(colorErro+'PROCESSO COM ERRO NO ENVIO PARA O ARCHIVEMATICA!! Uma nova tentativa sendo realizada...')

def verificaArquivo(infoServer, path, processo):
    with open(path, 'r') as lerLinhas:
        lines = lerLinhas.readlines()
        lerLinhas.close()

    if len(lines) > 0:
        for line in lines:
            id_archivematica = ((line.split(':'))[2]).strip('\n')

            urlstatus = infoServer[0] + ":" + infoServer[1] + "/api/transfer/status/" + id_archivematica + "/?username=" + infoServer[2] + "&api_key=" + infoServer[3]
            res = (requests.get(urlstatus)).json()

            if 'res' in locals():
                if 'name' in locals().get('res'):
                    processTemp = res['name'].split('.')
                    processNum = processTemp[0][9:] + processTemp[1]
                    processNum = re.sub(r'[_-]+', '', processNum)
                    if processo == processNum:
                       return True
    return False

def verificaStatus(infoServer,pastaRaiz):
    if os.path.exists('/logs/verificadorDeErros.json') is False:
        createJson = {}
        with open(pastaRaiz + '/logs/verificadorDeErros.json', 'w', encoding='utf-8') as gravarID:
            json.dump(createJson, gravarID, ensure_ascii=False, )
            gravarID.close()

    with open(pastaRaiz+"/logs/idEnviados.txt", "r") as lerLinhas:
        lines = lerLinhas.readlines()
        lerLinhas.close()

    if (len(lines)==0):
        print (colorFinish+"***Nenhuma Linha encontrada!***"+colorPass)

    with open(pastaRaiz+'/logs/idEnviados.txt', 'w') as gravarLinhas:
        for line in lines:
            id_banco = (line.split(':'))[0]
            id_archivematica = ((line.split(':'))[2].strip('\n'))

            urlstatus = infoServer[0] + ":" + infoServer[1] + "/api/transfer/status/"+id_archivematica+"/?username=" + infoServer[2] + "&api_key=" + infoServer[3]
            res = (requests.get(urlstatus)).json()

            if 'res' in locals():
                if 'status' in locals().get('res'):
                    if (res['status']) == 'COMPLETE':
                        uuidinj = res['sip_uuid']
                        uuidtransfer = res['uuid']
                        urlstatusinjest = infoServer[0] + ":" + infoServer[1] + "/api/ingest/status/"+uuidinj+"/?username=" + infoServer[2] + "&api_key=" + infoServer[3]
                        res1 = (requests.get(urlstatusinjest)).json()

                        if (res1['status']) == 'COMPLETE':
                            hidetransfer = infoServer[0] + ":" + infoServer[1] + "/api/transfer/" +id_archivematica + "/delete/?username=" + infoServer[2] + "&api_key=" + infoServer[3]
                            (requests.delete(hidetransfer)).json()

                            hideingest = infoServer[0] + ":" + infoServer[1] + "/api/ingest/" + uuidinj + "/delete/?username=" + infoServer[2] + "&api_key=" + infoServer[3]
                            (requests.delete(hideingest)).json()

                            print (colorFinish+'#################### Diário: '+id_banco+' arquivado! ####################'+colorPass)

                            with open(pastaRaiz+'/logs/arquivados.txt', 'a') as arquivados:
                                arquivados.write(line)
                            arquivados.close()

                            try:
                                shutil.rmtree(pastaRaiz + '/documentos/')
                                print(colorFinish+'# Deletado as pastas locais #'+colorPass)

                            except OSError as e:
                                print(colorErro + "Erro: %s - %s. \n" % (e.filename, e.strerror) + colorPass)

                        elif (res1['status']) == 'REJECTED' or (res1['status']) == 'FAILED':

                            with open(pastaRaiz + '/logs/idEnviados.txt', 'r') as gravarID:
                                relacao = gravarID.readlines()
                                gravarID.close()
                            with open(pastaRaiz + '/logs/verificadorDeErros.json', 'r', encoding='utf-8') as gravarID:
                                verificadorDeErros = json.load(gravarID)
                                gravarID.close()
                            if verificadorDeErros[id_banco] < 3:
                                with open(pastaRaiz + '/logs/verificadorDeID.txt', 'a') as gravarID:
                                    gravarID.write('\n' + id_banco)
                                    gravarID.close()

                            elif verificadorDeErros[id_banco] >= 3:
                                print(
                                    colorErro + '###Pacote: ' + id_banco + '; Número de tentativas esgotadas para este pacote.' + colorPass)

                            print (colorErro+'###Diário: '+id_banco+'; Transfer: OK; Injest: ERRO!'+colorPass)
                            gravarLinhas.write(id_banco+':0:'+id_archivematica+'\n')

                        else:
                            print (colorErro+'###Diário: '+id_banco+'; Transfer: OK; Injest: Processando!'+colorPass)
                            gravarLinhas.write(line)

                    elif (res['status']) == 'REJECTED' or (res['status']) == 'FAILED':
                        with open(pastaRaiz + '/logs/idEnviados.txt', 'r') as gravarID:
                            relacao = gravarID.readlines()
                            gravarID.close()
                        with open(pastaRaiz + '/logs/verificadorDeErros.json', 'r', encoding='utf-8') as gravarID:
                            verificadorDeErros = json.load(gravarID)
                            gravarID.close()
                        if verificadorDeErros[id_banco] < 3:
                            with open(pastaRaiz + '/logs/verificadorDeID.txt', 'a') as gravarID:
                                gravarID.write('\n' + id_banco)
                                gravarID.close()

                        elif verificadorDeErros[id_banco] >= 3:
                            print(colorErro + '###Pacote: ' + id_banco + '; Número de tentativas esgotadas para este pacote.' + colorPass)

                        print (colorErro+'###Diário: '+id_banco+'; Transfer: COM ERRO'+colorPass)
                        gravarLinhas.write(id_banco+':0:'+id_archivematica+'\n')

                    else:
                        print (colorErro+'###Diário: '+id_banco+'; Transfer: Processando; Injest: Não iniciado!'+colorPass)
                        gravarLinhas.write(line)

                else:
                    print (colorErro+'Erro ao enviar Diário: '+id_banco+'!'+colorPass)
                    gravarLinhas.write(id_banco+':0:'+id_archivematica+'\n')
            else:
                print (colorErro+'ERRO!'+colorPass)
                gravarLinhas.write(id_banco+':0:'+id_archivematica+'\n')

    gravarLinhas.close()
