from Imports import *

def envioArchivematica(infoServer,raiz,nomeArquivo,identificador,pastaRaiz, slug):
    """
        Executar o envio do pacote OAIS para o Archivematica e registro no log de pacotes enviados.

        :param infoServer: Informações necessárias para conexão com o Banco de Dados.
        :type infoServer: list
        :param raiz: Diretório do pacote OAIS.
        :type raiz: str
        :param nomeArquivo: Nome do pacote OAIS.
        :type nomeArquivo: str
        :param identificador: ID do diário no banco de dados.
        :type identificador: str
        :param pastaRaiz: Diretório do barramento.
        :type pastaRaiz: str
        :return: null
        """

    with open(pastaRaiz + '/logs/verificadorDeErros.json', 'r', encoding='utf-8') as gravarID:
        verificadorDeErros = json.load(gravarID)
        gravarID.close()
    lista = []
    novaEntrada = 0
    for x in verificadorDeErros:
        lista.append(x)
    for y in lista:
        if y == identificador:
            verificadorDeErros[identificador] = int(verificadorDeErros[identificador]) + 1
            novaEntrada = 1
    if novaEntrada == 0:
        verificadorDeErros[identificador] = 0
    with open(pastaRaiz + '/logs/verificadorDeErros.json', 'w', encoding='utf-8') as gravarID:
        json.dump(verificadorDeErros, gravarID, ensure_ascii=False, )
        gravarID.close()

    try:
        print('Enviando para Archivematica')
        arquivo = pastaRaiz+'/documentos/'+nomeArquivo+".zip"
        url = infoServer[0] + ":" + infoServer[1] + "/api/v2beta/package/?username=" + infoServer[2] + "&api_key=" + infoServer[3]
        diretorio = infoServer[4] + ':' + arquivo
        parametros = '{"name":"' + nomeArquivo + '","processing_config":"automated","access_system_id":"' + slug + '","auto_approve":true,"type":"' +infoServer[5] + '","path":"' + str(base64.b64encode(diretorio.encode("utf-8")), "utf-8") + '"}'
        resposta = (requests.post(url, data=parametros)).json()
        time.sleep(6)
        if ('id' in resposta):
            print('#################Realizando Transfer do arquivo: '+identificador+'!#################\n')

            with open(pastaRaiz + '/logs/idEnviados.txt', 'a') as gravarID:
                gravarID.write(identificador + ':1:' + resposta['id'] + '\n')
                gravarID.close()

            leituraArquivo = os.path.isfile(pastaRaiz + '/logs/verificadorDeIDAN.json')
            if (leituraArquivo):
                with open(pastaRaiz + '/logs/verificadorDeIDAN.json', 'r') as json_file:
                    linhas = json.load(json_file)
                    if (linhas != []):
                        linhas.remove(identificador)
                json_file.close()
                with open(pastaRaiz + '/logs/verificadorDeIDAN.json', 'w') as json_file:
                    json.dump(linhas,json_file)
                json_file.close()
                
            else:
                with open(pastaRaiz + '/logs/verificadorDeID.txt', 'r+') as gravarID:
                    linhas = gravarID.readlines()
                gravarID.close()

                with open(pastaRaiz + '/logs/verificadorDeID.txt', 'w') as gravarID:
                    if ((linhas[0].replace("\r", "").replace("\n", "").replace("\t", "").replace(" ", "")).isdecimal()):
                        gravarID.write(str(int(identificador) + 1))
                    else:
                        linhas = iter(linhas)
                        next(linhas)
                        for linha in linhas:
                            gravarID.write(linha)
        else:
            print (colorErro + resposta['message'] + colorPass)  
            exit()

    except Exception as e:
        print(colorErro + "Erro ao iniciar a transferencia para o Archivematica." + colorPass)
        print (e)
        quit()
