from Imports import *
from VerificaStatus import *
from ProximoArquivo import verificadorDeID
from EnvioArquivematica import envioArchivematica
from bagit import *

#Classe com funções generalizadas
class Geral:
    """

        Executa cada uma das etapas necessárias para a criação do pacote OAIS.

        """
    metadatas=0

    #Variaveis geradas dentro de funcoes da classe
    #sistema='Pje' ou 'Dje' (De acordo com o fornecido ao inicializar o codigo)
    #pastaRaiz= path onde este script esta localizado
    #root= XML dos metadados lido (O nome do xml deve ser igual a da variavel sistema, ie. Pje.xml ou Dje.xml)
    #infoServer= array com todos os dados necessarios para acessar o servidor do archivematica
    #cursor = retorno de conexaoComBanco
    #retornoConsultas= retorno de consultas
    #metadatas= Dicionario com todos os metadados gerados do sistema

    #Inicializa a classe
    def __init__(self, sistema,qtdEnvios):
        self.sistema=sistema
        self.numEnvios = 1
        self.qtdEnvios=qtdEnvios
        self.recuperaXML()
        print (colorFinish+'### Busca do XML realizada com sucesso ###'+colorPass)
        self.infoArchivematica()
        print (colorFinish+'### Informações Archivematica buscadas com sucesso ###'+colorPass)
        return


    #Obtem o arquivo XML
    def recuperaXML(self):
        """
                Mapeia o obtêm o arquivo XML.

                """
        pastaRaiz = os.path.abspath(__file__)  # Recupera o path do script python
        self.pastaRaiz= (os.path.split(pastaRaiz))[0]  # Recupera o path do projeto
        root = (ET.parse(self.pastaRaiz +'/sistemas/'+self.sistema + '/'+self.sistema+'.xml')).getroot()  # Abre o arquivo XML
        self.root = root
        return


    # Obtem as informacoes do archivematica
    def infoArchivematica(self):
        """
                Executa a função de extrair as informações do Archivematica.

                """
        self.infoServer = []

        # Recupera informaçoes do servidor do archivematica
        for servidor in self.root.iter('fileserver'):
            for mapping_tags in servidor:
                self.infoServer.append(mapping_tags.text)
        return self.infoServer

    # Verifica o status dos arquivos enviados na ultima execução bem-sucedida.
    ### Arquivo verificaStatus.py
    def status(self):
        """
                Executa a função de verificação do status da transferência.

                """
        return verificaStatus(self.infoServer, self.pastaRaiz)


    #Verifica se o processo já foi enviando, arquivado ou teve erro de envio
    ### Arquivo verificaStatus.py
    def processoRepetido(self, protocolo):
        verificaProcesso(self.infoServer, self.pastaRaiz, protocolo)

    # Realiza a obtenção dos dados
    ### Arquivo {SISTEMA}/ConexaoBanco
    def conexaoBanco(self):
        """
                Executa a função de conexão com o banco de dados do DJe.

                """
        exec('from sistemas.'+ self.sistema +'.ConexaoBanco'+self.sistema+' import *',globals())
        IdContinua = verificadorDeID(self.pastaRaiz,self.sistema)
        self.IdContinua = IdContinua
        #self.cursor=conexaoComBanco(self.root.iter('conections'),IdContinua)
        self.cursor,self.cursorAtom,self.webservice,self.url=conexaoComBanco(self.root.iter('conections'),IdContinua)
        return

    # Cria e trata a variavel contendo as informações que foram obtidas
    ### Arquivo {SISTEMA}/Consulta{SISTEMA}.py
    def geradorConsultas(self):
        """
        Executa a função de consulta dos metadados no banco de dados.

        """
        exec('from sistemas.'+ self.sistema +'.Consulta'+self.sistema+' import *',globals())
        #self.retornoConsultas=consultas(self.root.iter('metadatas'),self.cursor,1,self.IdContinua)
        self.processoRepetido(obtemProtocolo(self.cursor, self.root.iter('consultas')))
        
        self.retornoConsultas=consultas(self.root.iter('metadatas'),self.cursor,self.qtdEnvios,self.IdContinua,self.root,self.webservice,self.url)
        if (self.cursorAtom!=''):
            self.slug = obtemSlug(self.cursorAtom, self.retornoConsultas, self.root.iter('consultas'))
        else:
            self.slug = ''
        return

    # Função para geração dos metadados importado do arquivo Metadatas + 'Nome do projeto'
    def geradorMetadatas(self):
        """
        Executa a função de extração de metadados.

        """
        exec('from sistemas.'+ self.sistema +'.Metadatas'+self.sistema+' import *',globals())
        self.metadatas=geraMetadatas(self.root,self.retornoConsultas,self.cursor)

    # Função job
    def executarJob(self):
        """
                Executa a função job.

                """
        # exec('from sistemas.'+ self.sistema +'.Job'+self.sistema+' import *',globals())
        exec('from sistemas.'+ self.sistema +'.job import *', globals())

        exec('from sistemas.'+ self.sistema +'.job.CriarDiretorios import *', globals())
        exec('from sistemas.'+ self.sistema +'.job.CriarCsv import *', globals())
        exec('from sistemas.'+ self.sistema +'.job.BaixarArquivos import *', globals())
        exec('from sistemas.'+ self.sistema +'.job.CriarSubmissionDocumentation import *', globals())

        pastaArquivos = self.pastaRaiz+'/documentos'

        if (self.sistema == 'Dje'):
            metadados = self.metadatas[0]['metadados']
            subDoc = self.metadatas[0]['submissionDocumentation']
            nomesArquivos = self.metadatas[1][0]
            PDF = self.metadatas[2]

            metadados = metadados[0]
            nomeArquivo = (nomesArquivos).replace("'", "").replace("º", "o")
            pastaArquivo = pastaArquivos + '/' + nomeArquivo
            identificador = metadados[1][16]
            
            print('Criando estrutura de pastas para envio...')
            path = criarDiretorios(pastaArquivo)
            
            print('Gravando informações no CSV...')
            criarCsv(path,metadados)
            
            print('Criando Submission Documentation...')
            criarSubmissionDocumentation(path, subDoc)
            
            print('Baixando Diário ' + nomeArquivo + "...")
            baixarArquivos(nomeArquivo, PDF[0], path)

            print("Criando Bagit...")
            criarBagit(path,pastaArquivos,nomeArquivo)
            zipBag(path,pastaArquivos,nomeArquivo,pastaArquivo)
            #envioArchivematica(self.infoServer, pastaArquivo, nomeArquivo, identificador, self.pastaRaiz, "edi-o-co-edi-o-e-folder")

        elif (self.sistema == 'Pje'):
            metadados = self.metadatas
            nomeArquivo = metadados['metadados'][1][3]
            pastaArquivo = pastaArquivos+'/'+nomeArquivo
            identificador = self.IdContinua

            path = criarDiretorios(pastaArquivo)
            criarCsv(path,metadados)
            criarSubmissionDocumentation(path,metadados['submissionDocumentation'],0)
            baixarArquivos('',metadados,0,path)
            criarBagit(path,pastaArquivos,nomeArquivo)
            zipBag(path,pastaArquivos,nomeArquivo,pastaArquivo)
            envioArchivematica(self.infoServer, pastaArquivo, nomeArquivo, identificador, self.pastaRaiz, "edi-o-co-edi-o-e-folder")
                
        elif (self.sistema == 'An'):
            metadados = self.metadatas
            
            # nomeArquivo = ('Processo_'+str(metadados['metadados']['ProcedimentoFormatado'])+'.hipt').replace('/','_')
            nomeArquivo = ('Processo_'+str(metadados['metadados']['dc.identifier'])+'.hipt').replace('/','_')
            pastaArquivo = pastaArquivos+'/'+nomeArquivo
            identificador = self.IdContinua if self.IdContinua != -1 else str(metadados['metadados']['ProcedimentoFormatado'])

            print('Criando estrutura de pastas para envio...')
            path = criarDiretorios(pastaArquivo)

            print('Baixando ' + nomeArquivo + "...")
            baixarArquivos(nomeArquivo, metadados["objects"], path)
            
            print('Gravando informações no CSV...')
            criarCsv(path,metadados['metadados'])
            
            print('Criando Submission Documentation...')
            criarSubmissionDocumentation(path, metadados['submissionDocumentation'])

            print("Criando Bagit...")
            criarBagit(path,pastaArquivos,nomeArquivo)
            zipBag(path,pastaArquivos,nomeArquivo,pastaArquivo)
            envioArchivematica(self.infoServer, pastaArquivo, nomeArquivo, identificador, self.pastaRaiz, self.slug)

        else:
            print('Sistema não encontrado!')

    # Função para rodar todas as funções
    def runAll(self):
        """
                Executa todas as funções necessárias para funcionamento do barramento.

                """
        self.status()
        print(colorFinish+'### Realizado atualização dos arquivos texto! ###'+colorPass)

        self.conexaoBanco()
        print(colorFinish+'### Conexão com o banco realizada com sucesso! ###'+colorPass)

        self.geradorConsultas()
        print(colorFinish+'### Dados recuperados com sucesso! ###'+colorPass)

        self.geradorMetadatas()
        print(colorFinish+'### Gerado metadatas para criação do CSV ###'+colorPass)

        self.executarJob()
        
        print (colorFinish+'### Buscando novos envios! ###'+colorPass)
        self.numEnvios=self.numEnvios+1
        if (self.numEnvios <= self.qtdEnvios):
            novo.runAll()

        return

if __name__ == '__main__':
    novo=Geral('An',1)
    novo.runAll()
